#include <iostream>
#include <vector>

std::vector<int> resenje(std::vector<int>& trenutni, std::vector<int>& maximumi, std::pair<int, int>& upit) {
    int trenutniIndex = upit.first;
    int kolicina = upit.second;
    trenutni[trenutniIndex - 1] += kolicina;
    for (int i = 0; i < trenutni.size(); i++) {
        if (trenutni[i] > maximumi[i]) {
            int prebaceneZalbe = trenutni[i] - maximumi[i];
            trenutni[i] = maximumi[i];
            if (i + 1 < trenutni.size()) {
                trenutni[i + 1] += prebaceneZalbe;
            }
        }
    }
    return trenutni;
}

int main() {
    int n;
    std::cin >> n;
    std::vector<int> trenutni(n);
    for (int i = 0; i < n; i++) {
        std::cin >> trenutni[i];
    }
    std::vector<int> maximumi(n);
    for (int i = 0; i < n; i++) {
        std::cin >> maximumi[i];
    }
    int q;
    std::cin >> q;
    std::vector<std::pair<int, int>> upiti(q);
    for (int i = 0; i < q; i++) {
        std::cin >> upiti[i].first >> upiti[i].second;
    }
    std::vector<std::vector<int>> resenja;
    for (int i = 0; i < q; i++) {
        resenja.push_back(resenje(trenutni, maximumi, upiti[i]));
    }
    for (int i = 0; i < resenja[q - 1].size(); i++) {
        std::cout << resenja[q - 1][i] << " ";
    }
    return 0;
}